document.addEventListener('DOMContentLoaded', () => {
    const modal = document.getElementById('register-modal');
    const form = document.getElementById('reg-form');
    const openBtns = document.querySelectorAll('.open-form');
    const closeBtn = document.querySelector('.close-btn');
    const submitBtn = document.querySelector('.submit-btn');
    const statusDiv = document.getElementById('form-status');

    // Modal Control
    const toggleModal = (show) => {
        if (show) {
            modal.classList.add('active');
            document.body.style.overflow = 'hidden';
        } else {
            modal.classList.remove('active');
            document.body.style.overflow = '';
        }
    };

    openBtns.forEach(btn => btn.addEventListener('click', (e) => {
        e.preventDefault();
        toggleModal(true);
        form.scrollTop = 0;
    }));

    closeBtn.addEventListener('click', () => toggleModal(false));

    // Close on outside click
    modal.addEventListener('click', (e) => {
        if (e.target === modal) toggleModal(false);
    });

    // FAQ Accordion
    document.querySelectorAll('.faq-item').forEach(item => {
        item.querySelector('.faq-q').addEventListener('click', () => {
            item.classList.toggle('active');
        });
    });

    // Form Submission
    form.addEventListener('submit', async (e) => {
        e.preventDefault();
        console.log('Form submitted');

        // Reset status
        statusDiv.className = 'status-msg';
        statusDiv.textContent = '';
        submitBtn.disabled = true;
        const originalText = submitBtn.textContent;
        submitBtn.textContent = 'Processing...';

        const formData = new FormData(form);

        try {
            console.log('Sending request to submit.php');
            const response = await fetch('submit.php', {
                method: 'POST',
                body: formData
            });

            console.log('Response status:', response.status);
            const text = await response.text();
            console.log('Raw response:', text);
            
            let result;
            try {
                result = JSON.parse(text);
            } catch (e) {
                console.error('Failed to parse JSON:', text);
                throw new Error('Server returned invalid response: ' + text.substring(0, 100));
            }
            
            console.log('Result:', result);

            if (result.success) {
                // Show success view with download link
                const downloadLink = result.download_link;
                form.innerHTML = `
                    <div style="text-align: center; padding: 2rem 0;">
                        <div style="font-size: 3rem; margin-bottom: 1rem;">✅</div>
                        <h3 style="margin-bottom: 0.5rem; color: var(--text-main); font-size: 1.5rem;">Registration Successful!</h3>
                        <p style="color: var(--text-muted); margin-bottom: 2rem;">Your download link is ready</p>
                        
                        <a href="${downloadLink}" class="btn-primary" style="display: inline-block; padding: 1rem 2rem; margin-bottom: 1.5rem; text-decoration: none;">
                            📥 Download PDF Now
                        </a>
                        
                        <p style="color: var(--text-muted); font-size: 0.9rem; margin-top: 1rem;">⏰ Link expires in 1 hour</p>
                        
                        <div style="margin-top: 1.5rem; padding: 1rem; background: #f8fafc; border-radius: 8px; word-break: break-all;">
                            <p style="font-size: 0.85rem; color: var(--text-muted); margin-bottom: 0.5rem;">Or copy this link:</p>
                            <input type="text" value="${downloadLink}" readonly style="width: 100%; padding: 0.5rem; border: 1px solid #e2e8f0; border-radius: 4px; font-size: 0.85rem;" onclick="this.select()">
                        </div>
                    </div>
                `;
                
                // Auto-trigger download after 1 second
                setTimeout(() => {
                    window.location.href = downloadLink;
                }, 1000);
            } else {
                throw new Error(result.message || 'Submission failed');
            }

        } catch (error) {
            console.error('Error:', error);
            statusDiv.textContent = error.message;
            statusDiv.classList.add('error');
            statusDiv.style.display = 'block';
            submitBtn.disabled = false;
            submitBtn.textContent = originalText;
        }
    });
});
