<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard | Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/book/assets/css/admin.css">
</head>

<body>

    <!-- Sidebar -->
    <aside class="admin-sidebar">
        <div class="sidebar-header">
            Book Admin
        </div>
        <nav class="sidebar-nav">
            <a href="admin.php?action=dashboard" class="nav-item active">
                📊 Dashboard
            </a>
            <a href="admin.php?action=registrations" class="nav-item">
                👥 Registrations
            </a>
            <a href="admin.php?action=visits" class="nav-item">
                👁 Visits Log
            </a>
        </nav>
        <div class="sidebar-footer">
            <a href="admin.php?action=logout"
                style="color: #ef4444; text-decoration: none; font-size: 0.9rem;">
                ← Logout
            </a>
        </div>
    </aside>

    <!-- Main Content -->
    <main class="admin-main">
        <header class="main-header">
            <h1 class="page-title">Dashboard</h1>
            <div style="display: flex; gap: 1rem;">
                <a href="admin.php?action=export" class="btn-primary">Export CSV</a>
                <a href="admin.php?action=export-database" class="btn-primary" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%);">Export Database</a>
            </div>
        </header>

        <!-- KPI Cards -->
        <div class="grid-3">
            <div class="stat-card">
                <div class="stat-label">Total Registrations</div>
                <div class="stat-val"><?= number_format($stats['total_leads']) ?></div>
                <div style="font-size: 0.85rem; color: #16a34a; margin-top: 0.5rem;">
                    +<?= number_format($leads_7d) ?> last 7 days
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-label">Unique Visits (30d)</div>
                <div class="stat-val"><?= number_format($unique_visits_30d) ?></div>
                <div style="font-size: 0.85rem; color: var(--text-muted); margin-top: 0.5rem;">
                    Conversion: <?= $cr_30d ?>%
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-label">Top Country</div>
                <div class="stat-val" style="font-size: 1.5rem;">
                    <?= !empty($top_countries) ? htmlspecialchars($top_countries[0]['country_of_living']) : '-' ?>
                </div>
            </div>
        </div>

        <div class="grid-2">
            <!-- Recent Registrations -->
            <div class="table-card">
                <div class="table-header">
                    <h3 style="margin: 0; font-size: 1rem;">Recent Registrations</h3>
                    <a href="registrations"
                        style="font-size: 0.85rem; color: var(--primary); text-decoration: none;">View All</a>
                </div>
                <table class="admin-table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Degree</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($latest_leads as $lead): ?>
                            <tr>
                                <td>
                                    <div style="font-weight: 500;"><?= htmlspecialchars($lead['full_name']) ?></div>
                                    <div style="font-size: 0.8rem; color: var(--text-muted);">
                                        <?= htmlspecialchars($lead['country_of_living']) ?></div>
                                </td>
                                <td><span class="badge badge-blue"><?= htmlspecialchars($lead['last_degree']) ?></span></td>
                                <td><?= date('M d', strtotime($lead['created_at'])) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Top Countries -->
            <div class="table-card">
                <div class="table-header">
                    <h3 style="margin: 0; font-size: 1rem;">Top Countries</h3>
                </div>
                <table class="admin-table">
                    <tbody>
                        <?php foreach ($top_countries as $tc): ?>
                            <tr>
                                <td><?= htmlspecialchars($tc['country_of_living']) ?></td>
                                <td style="text-align: right; font-weight: 600;"><?= $tc['c'] ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>

</body>

</html>