<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrations | Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/book/assets/css/admin.css">
    <style>
        .pagination {
            display: flex;
            gap: 0.5rem;
            justify-content: flex-end;
            margin-top: 1rem;
        }

        .pagination a {
            padding: 0.5rem 0.75rem;
            border: 1px solid #e2e8f0;
            border-radius: 4px;
            color: #64748b;
            text-decoration: none;
        }

        .pagination a.active {
            background: #2563eb;
            color: white;
            border-color: #2563eb;
        }
    </style>
</head>

<body>

    <!-- Sidebar -->
    <aside class="admin-sidebar">
        <div class="sidebar-header">Book Admin</div>
        <nav class="sidebar-nav">
            <a href="admin.php?action=dashboard" class="nav-item">📊 Dashboard</a>
            <a href="admin.php?action=registrations" class="nav-item active">👥
                Registrations</a>
            <a href="admin.php?action=visits" class="nav-item">👁 Visits Log</a>
        </nav>
        <div class="sidebar-footer">
            <a href="admin.php?action=logout"
                style="color: #ef4444; text-decoration: none; font-size: 0.9rem;">← Logout</a>
        </div>
    </aside>

    <main class="admin-main">
        <header class="main-header">
            <h1 class="page-title">Registrations</h1>
            <a href="admin.php?action=export" class="btn-primary">Export CSV</a>
        </header>

        <!-- Filters -->
        <form method="GET" class="filter-bar">
            <input type="text" name="search" class="form-control" placeholder="Search..."
                value="<?= htmlspecialchars($_GET['search'] ?? '') ?>">

            <select name="country" class="form-control">
                <option value="">All Countries</option>
                <?php foreach ($countries as $c): ?>
                    <option value="<?= htmlspecialchars($c) ?>" <?= (($_GET['country'] ?? '') == $c) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($c) ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <select name="degree" class="form-control">
                <option value="">All Degrees</option>
                <?php foreach ($degrees as $d): ?>
                    <option value="<?= htmlspecialchars($d) ?>" <?= (($_GET['degree'] ?? '') == $d) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($d) ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <input type="date" name="date_from" class="form-control"
                value="<?= htmlspecialchars($_GET['date_from'] ?? '') ?>">
            <input type="date" name="date_to" class="form-control"
                value="<?= htmlspecialchars($_GET['date_to'] ?? '') ?>">

            <button type="submit" class="btn-primary">Filter</button>
            <a href="registrations" style="color: #64748b; text-decoration: none; font-size: 0.9rem;">Reset</a>
        </form>

        <div class="table-card">
            <table class="admin-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>User</th>
                        <th>Professional Info</th>
                        <th>WhatsApp</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($leads)): ?>
                        <tr>
                            <td colspan="4" style="text-align: center; color: var(--text-muted); padding: 2rem;">No
                                registrations found.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($leads as $lead): ?>
                            <tr>
                                <td>
                                    <div>
                                        <?= date('M d, Y', strtotime($lead['created_at'])) ?>
                                    </div>
                                    <div style="font-size: 0.8rem; color: var(--text-muted);">
                                        <?= date('H:i', strtotime($lead['created_at'])) ?>
                                    </div>
                                </td>
                                <td>
                                    <div style="font-weight: 500;">
                                        <?= htmlspecialchars($lead['full_name']) ?>
                                    </div>
                                    <div style="font-size: 0.85rem; color: var(--primary);">
                                        <?= htmlspecialchars($lead['email']) ?>
                                    </div>
                                    <div style="font-size: 0.8rem; color: var(--text-muted);">IP:
                                        <?= htmlspecialchars($lead['ip_address']) ?>
                                    </div>
                                </td>
                                <td>
                                    <div><span class="badge badge-blue">
                                            <?= htmlspecialchars($lead['last_degree']) ?>
                                        </span></div>
                                    <div style="margin-top:2px; font-size: 0.85rem;">
                                        <?= htmlspecialchars($lead['university']) ?>
                                    </div>
                                    <div style="font-size: 0.8rem; color: var(--text-muted);">
                                        <?= htmlspecialchars($lead['country_of_living']) ?>
                                    </div>
                                </td>
                                <td>
                                    <a href="https://wa.me/<?= preg_replace('/[^0-9]/', '', $lead['whatsapp_e164']) ?>"
                                        target="_blank" style="color: #16a34a; font-weight: 500; text-decoration:none;">
                                        <?= htmlspecialchars($lead['whatsapp_e164']) ?>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($total_pages > 1): ?>
            <div class="pagination">
                <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <?php
                    $q = $_GET;
                    $q['page'] = $i;
                    $queryStr = http_build_query($q);
                    ?>
                    <a href="?<?= $queryStr ?>" class="<?= $page == $i ? 'active' : '' ?>">
                        <?= $i ?>
                    </a>
                <?php endfor; ?>
            </div>
        <?php endif; ?>

    </main>
</body>

</html>