<?php
// Track Visit
if (class_exists('LeadController')) {
    // Optional: Track visit logic here if we were using a framework middleware
}
// Simple tracking insert (direct PDO usage for speed/inline)
$config = require __DIR__ . '/../config/config.php';
try {
    $dsn = "mysql:host={$config['db']['host']};dbname={$config['db']['dbname']};charset={$config['db']['charset']}";
    $pdo = new PDO($dsn, $config['db']['username'], $config['db']['password']);

    // Session Cookie
    if (!isset($_COOKIE['session_uuid'])) {
        $uuid = bin2hex(random_bytes(16));
        setcookie('session_uuid', $uuid, time() + (86400 * 30), "/");
    } else {
        $uuid = $_COOKIE['session_uuid'];
    }

    $ip = $_SERVER['REMOTE_ADDR'];
    $url = $_SERVER['REQUEST_URI'];
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
    
    // Tracking Parameters
    $referrer = $_SERVER['HTTP_REFERER'] ?? null;
    $utm_source = $_GET['utm_source'] ?? null;
    $utm_medium = $_GET['utm_medium'] ?? null;
    $utm_campaign = $_GET['utm_campaign'] ?? null;

    $stmt = $pdo->prepare("INSERT INTO page_views (session_uuid, page_url, ip_address, user_agent, referrer, utm_source, utm_medium, utm_campaign) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$uuid, $url, $ip, $ua, $referrer, $utm_source, $utm_medium, $utm_campaign]);

    // Admin setup removed - use setup_admin.php CLI script instead

} catch (Exception $e) { /* Ignore tracking errors */
}

// Initialize CSRF token
require_once __DIR__ . '/../src/SecurityHelper.php';
$csrfToken = SecurityHelper::generateCSRFToken();


// Board Members Data
$leads = [
    ['name' => 'Prof. A. Y. Rezk', 'role' => 'Lead Author', 'img' => 'assets/img/board/rezk.png'],
    ['name' => 'Prof. H. G. Al-Inany', 'role' => 'Lead Author', 'img' => 'assets/img/board/alinany.png'],
];

$dirmasBoard = [
    'Prof. Dr. Abdelhamid Attia',
    'Prof. Dr. Abdel-Maguid Sarhan',
    'Prof. Dr. AbouBakr ElNashar',
    'Prof. Dr. Momen Kamel',
    'Prof. Dr. Magdy Ibrahim',
    'Prof. Dr. Taiseer Maarouf',
    'Prof. Dr. Yousry Afifi'
];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ovarian Stimulation in IVF | Rezk & Al-Inany</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>

<body>

    <!-- Light Theme Orbs -->
    <div class="bg-gradient-orb orb-1"></div>
    <div class="bg-gradient-orb orb-2"></div>

    <nav>
        <div class="logo">
            <img src="assets/img/logo.png" alt="Rezk & Al-Inany" class="nav-logo">
        </div>
        <a href="#download" class="btn-primary open-form">Download PDF</a>
    </nav>

    <!-- Hero -->
    <header class="hero">
        <div class="book-container">
            <?php if (file_exists(__DIR__ . '/../assets/img/cover.png')): ?>
                <img src="assets/img/cover.png" alt="Book Cover" class="book-cover-img">
            <?php else: ?>
                <div class="book-placeholder">
                    <div style="font-weight: 800; font-size: 1.5rem; margin-bottom: 0.5rem; color: #1e293b;">OVARIAN
                        STIMULATION</div>
                    <div style="font-size: 0.9rem; color: #64748b; letter-spacing: 1px;">IN IVF</div>
                    <div style="margin-top: auto; font-size: 0.8rem; font-weight: 600;">Rezk & Al-Inany</div>
                </div>
            <?php endif; ?>
        </div>
        <h1>Master the Art & Science of Ovarian Stimulation</h1>
        <p>A practical, evidence-based guide designed for clinicians, fellows, and trainees in Reproductive Medicine.
        </p>
        <a href="#download" class="btn-primary btn-sticky">Get Your Copy</a>
    </header>

    <!-- Book Overview -->
    <section class="section">
        <div class="section-title">Why This Book Matters</div>
        <div style="max-width: 800px; margin: 0 auto; text-align: center; color: rgba(203, 213, 225, 0.9);">
            <p style="margin-bottom: 1.5rem;">
                Ovarian stimulation is the cornerstone of successful ART cycles. Yet, the literature can be dense and
                protocols vary widely.
                This book bridges the gap between academic research and daily clinical application.
            </p>
            <p>
                Written by leading experts, it provides a structured approach to patient assessment, protocol selection,
                and complication management,
                ensuring you have reliable decision-support at your fingertips.
            </p>
        </div>

        <div class="grid-cards" style="margin-top: 3rem;">
            <div class="card">
                <h3>What You'll Gain</h3>
                <ul style="list-style: none; color: rgba(203, 213, 225, 0.9);">
                    <li style="margin-bottom:0.5rem">✓ Practical Protocols & Dosing</li>
                    <li style="margin-bottom:0.5rem">✓ Pre-treatment Assessment</li>
                    <li style="margin-bottom:0.5rem">✓ Medication Selection Strategy</li>
                    <li style="margin-bottom:0.5rem">✓ Monitoring & Dose Adjustments</li>
                    <li style="margin-bottom:0.5rem">✓ OHSS Prevention & Management</li>
                    <li style="margin-bottom:0.5rem">✓ Clinical Pearls & Decision Aids</li>
                </ul>
            </div>
            <div class="card">
                <h3>Who This Is For</h3>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-top: 1rem;">
                    <span
                        style="background: #f1f5f9; padding: 0.5rem; border-radius: 4px; text-align: center; font-size: 0.9rem;">Clinicians</span>
                    <span
                        style="background: #f1f5f9; padding: 0.5rem; border-radius: 4px; text-align: center; font-size: 0.9rem;">Fellows</span>
                    <span
                        style="background: #f1f5f9; padding: 0.5rem; border-radius: 4px; text-align: center; font-size: 0.9rem;">IVF
                        Nurses</span>
                    <span
                        style="background: #f1f5f9; padding: 0.5rem; border-radius: 4px; text-align: center; font-size: 0.9rem;">Students</span>
                </div>
            </div>
        </div>
    </section>

    <!-- Inside the Book (TOC) -->
    <section class="section">
        <div class="section-title">What's Inside</div>
        <div class="grid-cards">
            <div class="card">
                <h3>1. Foundations</h3>
                <p>Physiology of the cycle & mechanism of action of gonadotropins.</p>
            </div>
            <div class="card">
                <h3>2. Assessment</h3>
                <p>Ovarian reserve testing and personalized patient planning.</p>
            </div>
            <div class="card">
                <h3>3. Protocols</h3>
                <p>Agonist vs Antagonist: When to choose what and why.</p>
            </div>
            <div class="card">
                <h3>4. Monitoring</h3>
                <p>Ultrasound and hormonal monitoring during stimulation.</p>
            </div>
            <div class="card">
                <h3>5. Triggering</h3>
                <p>Criteria for hCG vs Agonist trigger to optimize outcomes.</p>
            </div>
            <div class="card">
                <h3>6. Complications</h3>
                <p>Preventing and managing OHSS and poor response.</p>
            </div>
        </div>
    </section>

    <!-- Editorial Board -->
    <section class="section">
        <div class="section-title">Meet the Experts</div>

        <!-- Lead Authors -->
        <h3 style="text-align: center; margin-bottom: 2rem; color: rgba(203, 213, 225, 0.85);">Lead Authors</h3>
        <div class="board-grid" style="justify-content: center; margin-bottom: 3rem;">
            <?php foreach ($leads as $member): ?>
                <div class="board-card">
                    <img src="<?= $member['img'] ?>" alt="<?= $member['name'] ?>" class="board-img"
                        onerror="this.src='assets/img/board/placeholder.png'">
                    <div class="board-name"><?= $member['name'] ?></div>
                    <div class="board-role"><?= $member['role'] ?></div>
                </div>
            <?php endforeach; ?>
        </div>

        <!-- DIRMAS Board -->
        <h3 style="text-align: center; margin-bottom: 2rem; color: rgba(203, 213, 225, 0.85); margin-top: 3rem;">DIRMAS
            Board</h3>
        <div class="board-grid">
            <?php foreach ($dirmasBoard as $name): ?>
                <div class="board-card">
                    <img src="assets/img/board/placeholder.png" alt="<?= $name ?>" class="board-img">
                    <div class="board-name"><?= $name ?></div>
                    <div class="board-role">Board Member</div>
                </div>
            <?php endforeach; ?>
        </div>
    </section>

    <!-- FAQ -->
    <section class="section" style="max-width: 800px;">
        <div class="section-title">Frequently Asked Questions</div>

        <div class="faq-item">
            <div class="faq-q">Is this book free to download?</div>
            <div class="faq-a">Yes, but access is restricted to registered medical professionals for educational
                use.</div>
        </div>
        <div class="faq-item">
            <div class="faq-q">How do I receive the PDF?</div>
            <div class="faq-a">After registering, you will receive a secure download link via email.</div>
        </div>
        <div class="faq-item">
            <div class="faq-q">How long is the link valid?</div>
            <div class="faq-a">For security, the download link expires automatically after 2 hours.</div>
        </div>
        <div class="faq-item">
            <div class="faq-q">How is my data used?</div>
            <div class="faq-a">We use your data to verify your professional status and prevent abuse. We do not sell
                your data.</div>
        </div>
    </section>

    <!-- Download Section -->
    <section id="download" class="section"
        style="text-align: center; padding: 4rem 2rem; background: linear-gradient(135deg, rgba(30, 41, 59, 0.8) 0%, rgba(15, 23, 42, 0.8) 100%); border-top: 1px solid rgba(59, 130, 246, 0.3); border-bottom: 1px solid rgba(59, 130, 246, 0.3);">
        <div style="max-width: 600px; margin: 0 auto;">
            <h2 style="font-size: 2rem; font-weight: 800; margin-bottom: 1rem; color: #f1f5f9;">Ready to Master
                Ovarian Stimulation?</h2>
            <p style="color: rgba(203, 213, 225, 0.9); margin-bottom: 2rem; font-size: 1.1rem;">Join thousands of reproductive
                medicine professionals who rely on this guide.</p>
            <button class="btn-primary open-form" style="font-size: 1.2rem; padding: 1rem 3rem;">Download Now</button>
            <p style="margin-top: 1rem; font-size: 0.85rem; color: rgba(203, 213, 225, 0.7);">Format: PDF | Instant Email
                Delivery</p>
        </div>
    </section>

    <footer class="main-footer">
        <div class="footer-content">
            <div class="footer-col">
                <div class="footer-logo">Ovarian Stimulation in IVF</div>
                <p>Advancing Reproductive Medicine through education and evidence-based practice.</p>
            </div>
            <div class="footer-col">
                <h4>Quick Links</h4>
                <a href="#">Home</a>
                <a href="admin.php">Admin Portal</a>
            </div>
            <div class="footer-col">
                <h4>Legal</h4>
                <a href="terms">Terms of Service</a>
                <a href="privacy">Privacy Policy</a>
            </div>
            <div class="footer-col">
                <h4>Contact</h4>
                <p>Have questions?</p>
                <a href="mailto:info@dirmas.org" class="contact-link">info@dirmas.org</a>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; 2026 Rezk & Al-Inany. All rights reserved.</p>
        </div>
    </footer>

    <!-- Form Modal -->
    <div id="register-modal" class="modal-overlay">
        <div class="side-sheet">
            <button class="close-btn">&times;</button>
            <h2 style="font-size: 1.5rem; margin-bottom: 2rem; color: #f1f5f9;">Fill your informations to download
            </h2>

            <form id="reg-form">
                <input type="text" name="hp_field" style="display:none" tabindex="-1">
                <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrfToken, ENT_QUOTES, 'UTF-8') ?>">

                <div class="form-group">
                    <label>Full English Name</label>
                    <input type="text" name="full_name" required placeholder="Dr. John Doe">
                </div>

                <div class="form-group">
                    <label>WhatsApp Number</label>
                    <input type="tel" name="whatsapp_e164" required placeholder="+1234567890">
                </div>

                <div class="form-group">
                    <label>Email Address</label>
                    <input type="email" name="email" required placeholder="clinic@hospital.com">
                </div>

                <div class="form-group">
                    <label>University</label>
                    <input type="text" name="university" required placeholder="Cairo University">
                </div>

                <div class="form-group">
                    <label>Last Academic Degree</label>
                    <input type="text" name="last_degree" required placeholder="MBBS, Master's, PhD, etc.">
                </div>

                <div class="form-group">
                    <label>Country of Living</label>
                    <input type="text" name="country_of_living" required placeholder="Egypt">
                </div>

                <div class="checkbox-group">
                    <input type="checkbox" id="tc" name="terms_consent" required>
                    <label for="tc">Agree to Terms & Privacy.</label>
                </div>

                <div class="checkbox-group">
                    <input type="checkbox" id="mc" name="marketing_consent">
                    <label for="mc">Receive updates via Email/WhatsApp.</label>
                </div>

                <button type="submit" class="submit-btn" style="margin-top: 1.5rem;">Get Download Link</button>
                <div id="form-status" class="status-msg"></div>
            </form>
        </div>
    </div>

    <script src="assets/js/scroll-animations.js"></script>
</body>

</html>